
*======================================================
* Muslims Dataset -------------------------------------
*======================================================
set more off
quiet: do "INDIVIDUAL 2a. Prepare Variables TWM.do"

gen propcoreligionists = pctmuslims
gen zpropcoreligionists = zpctmuslims

keep COUNTRY WEIGHT icountry bonding1 verydifferent ///
	  son daughter fac_attitudes ///
	 freqpray edu age female rural personalecon favordem onetruefaith interfaith efficacy ///
	 loggdppc propcoreligionists SHI GRI polity2 rdi2010 mazhab sunnimuslim shiamuslim medummy ///
	 zbonding1 zson zdaughter zfac_attitudes ///
	 zfreqpray zedu zage zpersonalecon zefficacy ///
	 zloggdppc zpropcoreligionists zGRI zpolity2 zrdi
	 
gen muslim = 1

save "Temp Muslims.dta", replace


*======================================================
* Catholic Latin American Dataset ---------------------
*======================================================
set more off
quiet: do "INDIVIDUAL 2b. Prepare Variables RILA.do"

rename Country COUNTRY
replace COUNTRY = COUNTRY*100

gen propcoreligionists = pctcatholics
gen zpropcoreligionists = zpctcatholics

keep COUNTRY WEIGHT icountry bonding1 verydifferent ///
	 freqpray edu age female rural personalecon favordem onetruefaith interfaith ///
	 loggdppc propcoreligionists SHI GRI polity2 rdi2010 ///
	 zbonding1 ///
	 zfreqpray zedu zage zpersonalecon ///
	 zloggdppc zpropcoreligionists zGRI zpolity2 zrdi

gen muslim = 0
gen medummy = 0

append using "Temp Muslims.dta"



*======================================================
* Country Recoding
*======================================================
label define ctylabels 	100 "Argentina" 200 "Bolivia" 300 "Brazil" 400 "Chile" 500 "Colombia" 600 "Costa Rica" ///
						700 "Dominican Republic" 800 "Ecuador" 900 "El Salvador" 1000 "Guatemala" 1100 "Honduras" ///
						1200 "Mexico" 1300 "Nicaragua" 1400 "Panama" 1500 "Paraguay" 1600 "Peru" 1700 "Puerto Rico" ///
						1800 "Uruguay" 1900 "Venezuela" ///
						1 "Afghanistan" 2 "Albania" 3 "Algeria" 4 "Azerbaijan" 5 "Bangladesh" 6 "Bosnia and Herzegovina" ///
						7 "Egypt" 8 "Indonesia" 9 "Iran" 10 "Iraq" 11 "Jordan" 12 "Kazakhstan" 13 "Kosovo" 14 "Kyrgyzstan" ///
						15 "Lebanon" 16 "Malaysia" 17 "Morocco" 18 "Niger" 19 "Pakistan" 20 "Palestinian Territories" ///
						21 "Russia" 22 "Tajikistan" 23 "Thailand" 24 "Tunisia" 25 "Turkey" 26 "Uzbekistan"

label values COUNTRY ctylabels

replace icountry = "NA"
replace icountry = "Argentina" if COUNTRY==100
replace icountry = "Bolivia" if COUNTRY==200
replace icountry = "Brazil" if COUNTRY==300
replace icountry = "Chile" if COUNTRY==400
replace icountry = "Colombia" if COUNTRY==500
replace icountry = "Costa Rica" if COUNTRY==600
replace icountry = "Dominican Republic" if COUNTRY==700
replace icountry = "Ecuador" if COUNTRY==800
replace icountry = "El Salvador" if COUNTRY==900
replace icountry = "Guatemala" if COUNTRY==1000
replace icountry = "Honduras" if COUNTRY==1100
replace icountry = "Mexico" if COUNTRY==1200
replace icountry = "Nicaragua" if COUNTRY==1300
replace icountry = "Panama" if COUNTRY==1400
replace icountry = "Paraguay" if COUNTRY==1500
replace icountry = "Peru" if COUNTRY==1600
replace icountry = "Puerto Rico" if COUNTRY==1700
replace icountry = "Uruguay" if COUNTRY==1800
replace icountry = "Venezuela" if COUNTRY==1900

replace icountry = "Afghanistan" if COUNTRY==1
replace icountry = "Albania" if COUNTRY==2
replace icountry = "Algeria" if COUNTRY==3
replace icountry = "Azerbaijan" if COUNTRY==4
replace icountry = "Bangladesh" if COUNTRY==5
replace icountry = "Bosnia and Herzegovina" if COUNTRY==6
replace icountry = "Egypt" if COUNTRY==7
replace icountry = "Indonesia" if COUNTRY==8
replace icountry = "Iran" if COUNTRY==9
replace icountry = "Iraq" if COUNTRY==10
replace icountry = "Jordan" if COUNTRY==11
replace icountry = "Kazakhstan" if COUNTRY==12
replace icountry = "Kosovo" if COUNTRY==13
replace icountry = "Kyrgyzstan" if COUNTRY==14
replace icountry = "Lebanon" if COUNTRY==15
replace icountry = "Malaysia" if COUNTRY==16
replace icountry = "Morocco" if COUNTRY==17
replace icountry = "Niger" if COUNTRY==18
replace icountry = "Pakistan" if COUNTRY==19
replace icountry = "Palestinian Territories" if COUNTRY==20
replace icountry = "Russia" if COUNTRY==21
replace icountry = "Tajikistan" if COUNTRY==22
replace icountry = "Thailand" if COUNTRY==23
replace icountry = "Tunisia" if COUNTRY==24
replace icountry = "Turkey" if COUNTRY==25
replace icountry = "Uzbekistan" if COUNTRY==26


*======================================================
* Standardize Variables
*======================================================
egen zsonJOINED = std(son)
egen zdaughterJOINED = std(daughter)

egen zbonding1JOINED = std(bonding1)

egen zfreqprayJOINED = std(freqpray)
egen zeduJOINED = std(edu)
egen zageJOINED = std(age)
egen zefficacyJOINED = std(efficacy)
egen zpersonaleconJOINED = std(personalecon)

egen zloggdppcJOINED = std(loggdppc)
egen zpropcoreligionistsJOINED = std(propcoreligionists)
egen zSHIJOINED = std(SHI)
egen zGRIJOINED = std(GRI)
egen zpolity2JOINED = std(polity2)
egen zrdiJOINED = std(rdi2010)


*rm "Merged Muslims and Latin American - Pew.dta"
*save "Merged Muslims and Latin American - Pew.dta"

rm "Temp Muslims.dta"



*======================================================
* Change Variable Labels
*======================================================
label variable bonding1 "Religious Bonding"
label variable zbonding1 "Religious Bonding"
label variable freqpray "Frequency of Prayer"
label variable zfreqpray "Frequency of Prayer"
label variable edu "Education"
label variable zedu "Education"
label variable age "Age"
label variable zage "Age"
label variable female "Female"
label variable rural "Rural"
label variable efficacy "Political Efficacy"
label variable zefficacy "Political Efficacy"
label variable personalecon "Economic Condition"
label variable zpersonalecon "Economic Condition"
label variable favordem "Favor Democracy"
label variable onetruefaith "Own Faith One True Faith"
label variable interfaith "Interfaith Activities"
label variable loggdppc "Logged GDP per capita"
label variable zloggdppc "Logged GDP per capita"
label variable rdi "Religious Diversity"
label variable zrdi "Religious Diversity"
label variable GRI "Government Restriction"
label variable zGRI "Government Restriction"
label variable polity2 "Polity IV"
label variable zpolity2 "Polity IV"
  

*======================================================
* 3-Digit Country Code
*======================================================

gen countrycode = ""
replace countrycode = "AFG" if icountry == "Afghanistan"
replace countrycode = "ALB" if icountry == "Albania"
replace countrycode = "DZA" if icountry == "Algeria"
replace countrycode = "ARG" if icountry == "Argentina"
replace countrycode = "AZE" if icountry == "Azerbaijan"
replace countrycode = "BGD" if icountry == "Bangladesh"
replace countrycode = "BOL" if icountry == "Bolivia"
replace countrycode = "BRA" if icountry == "Brazil"
replace countrycode = "CHL" if icountry == "Chile"
replace countrycode = "COL" if icountry == "Colombia"
replace countrycode = "CRI" if icountry == "Costa Rica"
replace countrycode = "DOM" if icountry == "Dominican Republic"
replace countrycode = "ECU" if icountry == "Ecuador"
replace countrycode = "EGY" if icountry == "Egypt"
replace countrycode = "SLV" if icountry == "El Salvador"
replace countrycode = "GTM" if icountry == "Guatemala"
replace countrycode = "IDN" if icountry == "Indonesia"
replace countrycode = "IRN" if icountry == "Iran"
replace countrycode = "IRQ" if icountry == "Iraq"
replace countrycode = "JOR" if icountry == "Jordan"
replace countrycode = "KAZ" if icountry == "Kazakhstan"
replace countrycode = "RKS" if icountry == "Kosovo"
replace countrycode = "KGZ" if icountry == "Kyrgyzstan"
replace countrycode = "LBN" if icountry == "Lebanon"
replace countrycode = "MYS" if icountry == "Malaysia"
replace countrycode = "MEX" if icountry == "Mexico"
replace countrycode = "MAR" if icountry == "Morocco"
replace countrycode = "NIC" if icountry == "Nicaragua"
replace countrycode = "NER" if icountry == "Niger"
replace countrycode = "PAK" if icountry == "Pakistan"
replace countrycode = "PSE" if icountry == "Palestinian Territories"
replace countrycode = "PAN" if icountry == "Panama"
replace countrycode = "PRY" if icountry == "Paraguay"
replace countrycode = "PER" if icountry == "Peru"
replace countrycode = "PRI" if icountry == "Puerto Rico"
replace countrycode = "TJK" if icountry == "Tajikistan"
replace countrycode = "TUN" if icountry == "Tunisia"
replace countrycode = "TUR" if icountry == "Turkey"
replace countrycode = "UZB" if icountry == "Uzbekistan"
replace countrycode = "VEN" if icountry == "Venezuela"
